package UltimaDemo;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

import net.miginfocom.swing.MigLayout;

import SDK.SDKlib;
import SDK.SDKlib.Action;
import SDK.SDKlib.CardPosition;
import SDK.SDKlib.Config;
import SDK.SDKlib.EjectMode;
import SDK.SDKlib.IPData;
import SDK.SDKlib.IPMode;
import SDK.SDKlib.InfoMask;
import SDK.SDKlib.PrinterInfo;
import SDK.SDKlib.PrinterType;
import SDK.SDKlib.Response;
import SDK.SDKlib.Return;

import com.sun.jna.platform.win32.WinNT.HANDLE;
import com.sun.jna.platform.win32.WinNT.HANDLEByReference;
import com.sun.jna.ptr.ByteByReference;

import static UltimaDemo.Utils.*;
import static UltimaDemo.Main.InfoTab;
import static UltimaDemo.Main.EncodingTab;
import static UltimaDemo.Main.Driver1Tab;
import static UltimaDemo.Main.Driver2Tab;
import static UltimaDemo.Main.PrintDemoTab;

//====================================================================================

class Printer {
	static final int MAX_ERASECOUNT = 499;	//Maximum number of cards that can be erased
	static final int MAX_OFFSET     = 99;	//Maximum Smart card offset position
	
	private final String OPEN        = "OPEN";
	private final String CLOSE       = "CLOSE";
	private final String RESPONSE    = "RESPONSE";
	private final String MOVE        = "MOVE";
	private final String CLEAN       = "CLEAN";
	private final String RESTART     = "RESTART";
	private final String TEST        = "TEST";
	private final String EJECTMODE   = "EJECTMODE";
	private final String IPSETTINGS  = "IPSETTINGS";
	private final String RADIOGET    = "RADIOGET";
	private final String RADIOSET    = "RADIOSET";
	private final String CLEAR       = "CLEAR";

	private final ActionHandler ah = new ActionHandler();

	private final JPanel panelPrinter = new JPanel();
	private final JPanel cardsOpenCloseSession = new JPanel(new CardLayout());
	private final JPanel panelOpen = new JPanel();
	private final JPanel panelClose = new JPanel();
	private final JButton btnOpenSession = new JButton("Open Session");
	private final JButton btnCloseSession = new JButton("Close Session");
	private final JComboBox<ComboItem> comboOpenSession = new JComboBox<>();

	private final JPanel panelErrorResponse = new JPanel();
	private final JComboBox<ComboItem> comboErrorResponse = new JComboBox<>();
	private final JButton btnErrorResponse = new JButton("Error Response");

	private final JPanel panelPrinterControl = new JPanel();
	private final JButton btnMoveCard = new JButton("Move Card");
	private final JComboBox<ComboItem> comboMoveCard = new JComboBox<ComboItem>();
	private final JButton btnCleanPrinter = new JButton("Clean Printer");
	private final JButton btnTestCard = new JButton("Print Test Card");
	private final JButton btnRestartPrinter = new JButton("Restart Printer");
	
	private final JPanel panelAction = new JPanel();
	private final JPanel panelPrinterConfig = new JPanel();
	private final JLabel labelAction = new JLabel("Action:");
	private final JRadioButton rdbtnGet = new JRadioButton("Get");
	private final JRadioButton rdbtnSet = new JRadioButton("Set");
	private final ButtonGroup buttonGroup = new ButtonGroup();

	private final JPanel panelEjectMode = new JPanel();
	private final JComboBox<ComboItem> comboEjectMode = new JComboBox<ComboItem>();
	private final JButton btnEjectMode = new JButton("Eject Mode");

	private final JPanel panelIPSettings = new JPanel();
	private final JLabel labelMode = new JLabel("Mode");
	private final JComboBox<ComboItem> comboIPMode = new JComboBox<ComboItem>();
	private final JLabel labelAddress = new JLabel("Address");
	private final JTextField textIPAddress = new JTextField();
	private final JLabel labelSubnet = new JLabel("Subnet");
	private final JTextField textIPSubnet = new JTextField();
	private final JLabel labelGateway = new JLabel("Gateway");
	private final JTextField textIPGateway = new JTextField();
	private final JButton btnIPSettings = new JButton("IP Settings");

	private final JPanel panelPrinterMsg = new JPanel();
	private final JTextArea textPrinterMsg = new JTextArea();
	private final JScrollPane scrollPane = new JScrollPane(textPrinterMsg);    
	private final JButton btnClear = new JButton("Clear");

	private JTabbedPane tabbedPane;

	private HANDLE hSession; 
	private SDKlib SDK = new SDKlib();

	static PrinterJob pj;
	
	//====================================================================================

	protected Printer(JTabbedPane mainTab) {
		tabbedPane = mainTab;
		tabbedPane.addTab("Printer", null, panelPrinter, null);

		panelPrinter.setLayout(new MigLayout("", "[152.00px][100.00px][248px][167px]", "[53px][120.00][444.00px]"));
		
		// ===== Session Control =====
		cardsOpenCloseSession.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), 
										                 "Session Control",
										                 TitledBorder.LEADING, 
										                 TitledBorder.TOP, 
										                 null,
										                 new Color(0, 0, 0)));
		panelPrinter.add(cardsOpenCloseSession, "cell 0 0 2 1,grow");
		cardsOpenCloseSession.add(panelOpen, "OpenSessionPanel");
		cardsOpenCloseSession.add(panelClose, "CloseSessionPanel");

		panelOpen.setLayout(new MigLayout("", "[][grow]", "[]"));
		btnOpenSession.setActionCommand(OPEN);
		btnOpenSession.addActionListener(ah);
		panelOpen.add(btnOpenSession, "cell 0 0");

		comboOpenSession.addItem(new ComboItem("Config Normal", Config.NORMAL));
		comboOpenSession.addItem(new ComboItem("Config Quiet",  Config.QUIET));
		panelOpen.add(comboOpenSession, "cell 1 0,growx");

		btnCloseSession.setActionCommand(CLOSE);
		btnCloseSession.addActionListener(ah);
		panelClose.add(btnCloseSession);
		
		// ===== Error Response =====
		panelErrorResponse.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), 
				                                      "Error Handling",
				                                      TitledBorder.LEADING, 
				                                      TitledBorder.TOP, 
				                                      null,
				                                      new Color(0, 0, 0)));
		panelPrinter.add(panelErrorResponse, "cell 2 0 2 1,grow");
		panelErrorResponse.setLayout(new MigLayout("", "[167px,grow]", "[53px][]"));
		comboErrorResponse.setEnabled(false);

		comboErrorResponse.addItem(new ComboItem("OK",     Response.OK));
		comboErrorResponse.addItem(new ComboItem("Cancel", Response.CANCEL));
		panelErrorResponse.add(comboErrorResponse, "cell 0 0,growx");
		btnErrorResponse.setEnabled(false);

		panelErrorResponse.add(btnErrorResponse, "cell 0 1,alignx center");
		btnErrorResponse.setActionCommand(RESPONSE);
		btnErrorResponse.addActionListener(ah);
		btnErrorResponse.setEnabled(false);

		// ===== Printer Control =====
		panelPrinterControl.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), 
				                                       "Printer Control",
				                                       TitledBorder.LEADING, 
				                                       TitledBorder.TOP, 
				                                       null,
				                                       new Color(0, 0, 0)));
		panelPrinter.add(panelPrinterControl, "cell 0 1 2 1,grow");
		panelPrinterControl.setLayout(new MigLayout("", "[][94.00]", "[][][]"));

		panelPrinterControl.add(btnMoveCard, "cell 0 0,growx");
		btnMoveCard.setActionCommand(MOVE);
		btnMoveCard.addActionListener(ah);
		btnMoveCard.setEnabled(false);
		panelPrinterControl.add(comboMoveCard, "cell 1 0,growx");
		comboMoveCard.addItem(new ComboItem("Transfer Standby",    CardPosition.TRANSFER_STANDBY));
		comboMoveCard.addItem(new ComboItem("Heated Roller",       CardPosition.HEATED_ROLLER));
		comboMoveCard.addItem(new ComboItem("Flip Standby",        CardPosition.FLIP_STANDBY));
		comboMoveCard.addItem(new ComboItem("Rotate",              CardPosition.ROTATE));
		comboMoveCard.addItem(new ComboItem("Mag Encoder",         CardPosition.MAG_ENCODER));
		comboMoveCard.addItem(new ComboItem("Contact Encoder",     CardPosition.CONTACT_ENCODER));
		comboMoveCard.addItem(new ComboItem("Eject",               CardPosition.EJECT));
		comboMoveCard.addItem(new ComboItem("Reject",              CardPosition.REJECT));
		comboMoveCard.addItem(new ComboItem("Laminator",           CardPosition.LAMINATOR));
		comboMoveCard.addItem(new ComboItem("Contactless Encoder", CardPosition.CONTACTLESS_ENCODER));
		comboMoveCard.setEnabled(false);

		panelPrinterControl.add(btnCleanPrinter, "cell 0 1,growx");
		btnCleanPrinter.setActionCommand(CLEAN);
		btnCleanPrinter.addActionListener(ah);
		btnCleanPrinter.setEnabled(false);

		panelPrinterControl.add(btnRestartPrinter, "cell 1 1");
		btnRestartPrinter.setActionCommand(RESTART);
		btnRestartPrinter.addActionListener(ah);
		btnRestartPrinter.setEnabled(false);

		panelPrinterControl.add(btnTestCard, "cell 0 2");
		btnTestCard.setActionCommand(TEST);
		btnTestCard.addActionListener(ah);
		btnTestCard.setEnabled(false);

		// ===== Printer Config =====
		panelPrinter.add(panelPrinterConfig, "cell 0 2 2 1,growx,aligny top");
		panelPrinterConfig.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), 
									                  "Printer Config", 
									                  TitledBorder.LEADING, 
									                  TitledBorder.TOP, 
									                  null, 
									                  new Color(0, 0, 0)));
		panelPrinterConfig.setLayout(new MigLayout("", "[grow][grow]", "[][][337.00,grow]"));
		panelPrinterConfig.add(panelAction, "cell 0 0 2 1,grow");
		panelAction.add(labelAction);
		panelAction.add(rdbtnGet);
		rdbtnGet.setEnabled(false);
		rdbtnGet.setSelected(true);
		buttonGroup.add(rdbtnGet);
		rdbtnGet.setActionCommand(RADIOGET);
		rdbtnGet.addActionListener(ah);
		buttonGroup.add(rdbtnSet);
		panelAction.add(rdbtnSet);
		rdbtnSet.setEnabled(false);
		buttonGroup.add(rdbtnSet);
		rdbtnSet.setActionCommand(RADIOSET);
		rdbtnSet.addActionListener(ah);
		
		panelPrinterConfig.add(panelEjectMode, "cell 0 1 2 1,grow");
		panelEjectMode.setLayout(new MigLayout("", "[grow]", "[]"));
		panelEjectMode.add(btnEjectMode, "flowx,cell 0 0,growx");
		panelEjectMode.add(comboEjectMode, "cell 0 0,growx");
		comboEjectMode.addItem(new ComboItem("Off", EjectMode.OFF));
		comboEjectMode.addItem(new ComboItem("On",  EjectMode.ON));
		comboEjectMode.setEnabled(false);
		btnEjectMode.setEnabled(false);
		btnEjectMode.setActionCommand(EJECTMODE);
		btnEjectMode.addActionListener(ah);

		panelPrinterConfig.add(panelIPSettings, "cell 0 2 2 1,growx,aligny top");
		panelIPSettings.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), 
								                   "", 
								                   TitledBorder.LEADING, 
								                   TitledBorder.TOP, 
								                   null,
								                   new Color(0, 0, 0)));
		panelIPSettings.setLayout(new MigLayout("", "[][grow]", "[][][][][]"));

		panelIPSettings.add(labelMode, "cell 0 0,alignx left");
		panelIPSettings.add(comboIPMode, "cell 1 0,growx");
		comboIPMode.addItem(new ComboItem("Static",  IPMode.STATIC));
		comboIPMode.addItem(new ComboItem("Dynamic", IPMode.DYNAMIC));
		comboIPMode.setEnabled(false);

		panelIPSettings.add(labelAddress, "cell 0 1,alignx left");
		panelIPSettings.add(textIPAddress, "cell 1 1,growx");
		textIPAddress.setEnabled(false);

		panelIPSettings.add(labelSubnet, "cell 0 2,alignx left");
		panelIPSettings.add(textIPSubnet, "cell 1 2,growx");
		textIPSubnet.setEnabled(false);

		panelIPSettings.add(labelGateway, "cell 0 3,alignx left");
		panelIPSettings.add(textIPGateway, "cell 1 3,growx");
		textIPGateway.setEnabled(false);

		panelIPSettings.add(btnIPSettings, "cell 0 4 2 1,alignx center");
		btnIPSettings.setActionCommand(IPSETTINGS);
		btnIPSettings.addActionListener(ah);
		btnIPSettings.setEnabled(false);

		// ===== Printer Msg =====
		panelPrinter.add(panelPrinterMsg, "cell 2 1 2 2,grow");
		panelPrinterMsg.setLayout(new MigLayout("", "[grow]", "[grow][]"));
		panelPrinterMsg.add(scrollPane, "cell 0 0,grow");
		textPrinterMsg.setEditable(false);
		textPrinterMsg.setBorder(BorderFactory.createLineBorder(Color.black));
		
		panelPrinterMsg.add(btnClear, "cell 0 1,alignx center");
		btnClear.setActionCommand(CLEAR);
		btnClear.addActionListener(ah);
		
		textPrinterMsg.append("Demo Version: "      + demoVersion + "\n");
		textPrinterMsg.append("Java Shim Version: " + SDK.shimVersion  + "\n");
		textPrinterMsg.append(SDK.ID_SDKBits() +" Bit SDK\n\n");
	}

    //====================================================================================

	private void GetSetControls(Boolean state) {
		comboEjectMode.setEnabled(state);
		comboIPMode.setEnabled(state);
		textIPAddress.setEnabled(state);
		textIPSubnet.setEnabled(state);
		textIPGateway.setEnabled(state);
	}

	//------------------------------------------------------------------------------------

	private void EnableControls(Boolean state) {
		btnMoveCard.setEnabled(state);
		comboMoveCard.setEnabled(state);
		btnTestCard.setEnabled(state);
		btnCleanPrinter.setEnabled(state);
		btnRestartPrinter.setEnabled(state);
		btnErrorResponse.setEnabled(state);
		comboErrorResponse.setEnabled(state);
		rdbtnGet.setEnabled(state);
		rdbtnSet.setEnabled(state);
		btnEjectMode.setEnabled(state);
		btnIPSettings.setEnabled(state);

		GetSetControls(rdbtnSet.isSelected());
	}

	//------------------------------------------------------------------------------------

	private void ClearMsg() {
		textPrinterMsg.setText(null);
	}

	//====================================================================================

	private void OpenSession() {
		pj = PrinterJob.getPrinterJob();
		if (pj.printDialog()) {
			CursorWait();
			
			HANDLEByReference HandleRef = new HANDLEByReference();
	    	byte sdkReturn = SDK.ID_OpenSession(pj.getPrintService().getName(), 
	    										HandleRef, 
	    										((ComboItem)comboOpenSession.getSelectedItem()).getValue());	
	    	if (sdkReturn != Return.SUCCESS) {
				DisplayError("OpenSession", sdkReturn);
			}
			else {
				hSession = HandleRef.getValue();
				
				//Call the SDK to get the printer model
				if (SDK.ID_PrinterType(hSession) != PrinterType.ULTIMA) {
					JOptionPane.showMessageDialog(null, 
												  "Invalid Printer - Ultima Only", 
												  "SDK ERROR", 
												  JOptionPane.INFORMATION_MESSAGE);
					SDK.ID_CloseSession(hSession);
				}
				else {
					EnableControls(true);
	
					//Select the 'Close Session' card
					CardLayout cl = (CardLayout)(cardsOpenCloseSession.getLayout());
					cl.last(cardsOpenCloseSession);
					
			        InfoTab.Init(hSession, SDK);
					EncodingTab.Init(hSession, SDK);
					Driver1Tab.Init(hSession, SDK);
					Driver2Tab.Init(hSession, SDK, pj.getPrintService().getName());
					PrintDemoTab.Init(hSession, SDK);
					
					//Get Printer Info to Initialise the dialog fields
					PrinterInfo PI = new PrinterInfo();
					sdkReturn = SDK.ID_PrinterInfo(hSession, PI);
					if (sdkReturn != Return.SUCCESS) {
						DisplayError("Open-GetPrinterInfo", sdkReturn);
					}
					else {
						EjectModeDisplay((PI.bitFields  & InfoMask.EJECT_MODE) != 0 
								         ? EjectMode.ON : EjectMode.OFF);
	
						GetIPSettings(new IPData());
					}
					
					//Force a resize of the main Frame
					((JFrame)tabbedPane.getTopLevelAncestor()).pack();
				}
			}
	    	
	    	CursorDefault();
		}
	}

	//====================================================================================

	private void CloseSession() {
		//Select the 'Open Session' card
		CardLayout cl = (CardLayout)(cardsOpenCloseSession.getLayout());
		cl.first(cardsOpenCloseSession);
		
		tabbedPane.remove(Info.panelInfo);
		tabbedPane.remove(Encoding.panelEncoding);
		tabbedPane.remove(Driver1.panelDriver1);
		tabbedPane.remove(Driver2.panelDriver2);
		tabbedPane.remove(PrintDemo.panelPrintDemo);

		EnableControls(false);

		byte sdkReturn = SDK.ID_CloseSession(hSession);	
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("CloseSession", sdkReturn);
		}
	}
	
	//====================================================================================

	private void MoveCard() {
		CursorWait();
		
		byte sdkReturn = SDK.ID_MoveCard(hSession, 
										 ((ComboItem)comboMoveCard.getSelectedItem()).getValue());
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("MoveCard", sdkReturn);
		}
		else {
			sdkReturn = WaitForPrinterToFinish(hSession, SDK);
			if (sdkReturn != Return.SUCCESS) {
				DisplayError("MoveCardWait", sdkReturn);
			}
		}

		CursorDefault();
	}
	
	//====================================================================================

	private void ErrorResponse() {
		byte sdkReturn = SDK.ID_ErrorResponse(hSession, 
											  ((ComboItem)comboErrorResponse.getSelectedItem()).getValue());	
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("ErrorResponse", sdkReturn);
		}
	}
	
	//====================================================================================

	private void CleanPrinter() {
		CursorWait();
		
		byte sdkReturn = SDK.ID_CleanPrinter(hSession);	
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("CleanPrinter", sdkReturn);
		}
		else {
			sdkReturn = WaitForPrinterToFinish(hSession, SDK);
			if (sdkReturn != Return.SUCCESS) {
				DisplayError("CleanPrinterWait", sdkReturn);
			}
		}
		
		CursorDefault();
	}

	//====================================================================================

	private void RestartPrinter() {
		CursorWait();
		
		byte sdkReturn = SDK.ID_RestartPrinter(hSession);	
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("RestartPrinter", sdkReturn);
		}
		else {
			sdkReturn = WaitForPrinterToFinish(hSession, SDK);
			if (sdkReturn != Return.SUCCESS) {
				DisplayError("RestartPrinterWait", sdkReturn);
			}
		}
    	
		CursorDefault();
	}

	//====================================================================================

	private void PrintTestCard() {
		CursorWait();
		
		byte sdkReturn = SDK.ID_PrintTestCard(hSession);	
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("PrintTestCard", sdkReturn);
		}
		else {
			sdkReturn = WaitForPrinterToFinish(hSession, SDK);
			if (sdkReturn != Return.SUCCESS) {
				DisplayError("PrintTestCardWait", sdkReturn);
			}
		}
		
		CursorDefault();
	}

	//====================================================================================

	private String EjectModeString(byte mode) {
		return comboEjectMode.getItemAt(mode).toString();
	}

	//------------------------------------------------------------------------------------

	private void EjectModeDisplay(byte mode) {
		comboEjectMode.setSelectedIndex(mode);
	}

	//------------------------------------------------------------------------------------

	private void EjectModeToMsgBox(byte action, byte mode) {
		textPrinterMsg.append("Eject Mode" + Separator(action) + EjectModeString(mode) + "\n\n");
	}
	
	//------------------------------------------------------------------------------------

	private byte GetEjectMode(ByteByReference mode) {
		CursorWait();

		byte sdkReturn = SDK.ID_EjectMode(hSession, Action.READ, mode);
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("GetEjectMode", sdkReturn);
		}
		else {
			EjectModeDisplay(mode.getValue());
		}

		CursorDefault();
		return sdkReturn;
	}
	
	//------------------------------------------------------------------------------------

	private void EjectMode() {
		ByteByReference mode = new ByteByReference(((ComboItem)comboEjectMode.getSelectedItem()).getValue());
		if (rdbtnGet.isSelected()) {
			if (GetEjectMode(mode) == Return.SUCCESS) {
				EjectModeToMsgBox(Action.READ, mode.getValue());
			}
		}
		else {
			byte sdkReturn = SDK.ID_EjectMode(hSession, Action.WRITE, mode);	
			if (sdkReturn != Return.SUCCESS) {
				DisplayError("EjectMode", sdkReturn);
			}
			else {
				EjectModeToMsgBox(Action.WRITE, mode.getValue());
			}
		}
	}

	//====================================================================================

	private String IPModeString(byte mode) {
		return comboIPMode.getItemAt(mode).toString();
	}

	//------------------------------------------------------------------------------------

	private void IPSettingsToMsgBox(byte action, IPData IP) {
		String sep = Separator(action);
		textPrinterMsg.append("IP Settings:\n" 
				              + "Address Mode" + sep + IPModeString(IP.mode)    + "\n"
				              + "IP Address"   + sep + IP.getString(IP.address) + "\n"
				              + "Subnet"       + sep + IP.getString(IP.subnet)  + "\n"
				              + "Gateway"      + sep + IP.getString(IP.gateway) + "\n\n");
	}
	
	//------------------------------------------------------------------------------------

	private void IPSettingsToCtrl(IPData IP) {
		comboIPMode.setSelectedIndex(IP.mode);
		textIPAddress.setText(IP.getString(IP.address));
		textIPSubnet.setText(IP.getString(IP.subnet));
		textIPGateway.setText(IP.getString(IP.gateway));
	}

	//------------------------------------------------------------------------------------

	private byte GetIPSettings(IPData IP) {
		byte sdkReturn = SDK.ID_IPSettings(hSession, Action.READ, IP);
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("GetIPSettings", sdkReturn);
		}

		return sdkReturn;
	}
	
	//------------------------------------------------------------------------------------

	private void IPSettings() {
		CursorWait();

		IPData IP = new IPData();		
		if (rdbtnGet.isSelected()) {
			if (GetIPSettings(IP) == Return.SUCCESS) {
				IPSettingsToMsgBox(Action.READ, IP);
				IPSettingsToCtrl(IP);
			}
		}
		else {
			IP.mode    = ((ComboItem)comboIPMode.getSelectedItem()).getValue();
 			IP.address = IP.getInt(textIPAddress.getText());
			IP.subnet  = IP.getInt(textIPSubnet.getText());
			IP.gateway = IP.getInt(textIPGateway.getText());

			byte sdkReturn = SDK.ID_IPSettings(hSession, Action.WRITE, IP);	
			if (sdkReturn != Return.SUCCESS) {
				DisplayError("IPSettings", sdkReturn);
			}
			else {
				IPSettingsToMsgBox(Action.WRITE, IP);
			}
		}

		CursorDefault();
	}

	//====================================================================================

	class ActionHandler implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			switch (e.getActionCommand()) {
			case RADIOGET:    GetSetControls(false); break;
			case RADIOSET:    GetSetControls(true);  break;
			case OPEN:        OpenSession();         break;
			case CLOSE:       CloseSession();        break;
			case RESPONSE:    ErrorResponse();       break;
			case CLEAR:       ClearMsg();            break;
			case MOVE:        MoveCard();            break;
			case CLEAN:       CleanPrinter();        break;
			case RESTART:     RestartPrinter();      break;
			case TEST:        PrintTestCard();       break;
			case EJECTMODE:   EjectMode();           break;
			case IPSETTINGS:  IPSettings();          break;
			}
		}
	}
}
